// $Id$
// Author: Yves Lafon <ylafon@w3.org>
//
// (c) COPYRIGHT MIT, ERCIM and Keio University, 2012.
// Please first read the full copyright statement in file COPYRIGHT.html
package org.w3c.css.properties.css21;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssTypes;
import org.w3c.css.values.CssValue;

/**
 * @spec http://www.w3.org/TR/2011/REC-CSS2-20110607/generate.html#propdef-list-style-type
 */
public class CssListStyleType extends org.w3c.css.properties.css.CssListStyleType {

	public static final CssIdent[] allowed_values;

	static {
		String[] _allowed_values = {"none", "disc", "circle", "square", "decimal",
				"decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek",
				"lower-latin", "upper-latin", "armenian", "georgian", "lower-alpha",
				"upper-alpha"};
		int i = 0;
		allowed_values = new CssIdent[_allowed_values.length];
		for (String s : _allowed_values) {
			allowed_values[i++] = CssIdent.getIdent(s);
		}
	}

	public static final CssIdent getAllowedIdent(CssIdent ident) {
		for (CssIdent id : allowed_values) {
			if (id.equals(ident)) {
				return id;
			}
		}
		return null;
	}

	/**
	 * Create a new CssListStyleType
	 */
	public CssListStyleType() {
	}


	/**
	 * Set the value of the property<br/>
	 * Does not check the number of values
	 *
	 * @param expression The expression for this property
	 * @throws org.w3c.css.util.InvalidParamException
	 *          The expression is incorrect
	 */
	public CssListStyleType(ApplContext ac, CssExpression expression)
			throws InvalidParamException {
		this(ac, expression, false);
	}

	/**
	 * Set the value of the property
	 *
	 * @param expression The expression for this property
	 * @param check      set it to true to check the number of values
	 * @throws org.w3c.css.util.InvalidParamException
	 *          The expression is incorrect
	 */
	public CssListStyleType(ApplContext ac, CssExpression expression,
							boolean check) throws InvalidParamException {
		if (check && expression.getCount() > 1) {
			throw new InvalidParamException("unrecognize", ac);
		}
		setByUser();

		CssValue val;
		char op;

		val = expression.getValue();
		op = expression.getOperator();

		if (val.getType() != CssTypes.CSS_IDENT) {
			throw new InvalidParamException("value", val,
					getPropertyName(), ac);
		}
		CssIdent id = (CssIdent) val;
		if (inherit.equals(id)) {
			value = inherit;
		} else {
			value = getAllowedIdent(id);
			if (value == null) {
				throw new InvalidParamException("value",
						val.toString(),
						getPropertyName(), ac);
			}
		}
		expression.next();
	}

}
